//-----------------------------------------------------------------------------------
//Cgw_SceneNameConfirmFix.js
//-----------------------------------------------------------------------------------
/*:
 * @plugindesc 名前の入力シーンのマウスとキーボード同時決定時のクラッシュ防止
 * @author 茶川あくた（AkutaChagawa）
 * @target MV MZ
 * @help
 * 【概要】
 * 名前の入力シーン（Scene_Name）で「決定」をキーボードとマウスで
 * 同時に押下した時にクラッシュすることがある不具合を防止するプラグインです。
 * 同時押しにより決定処理が二重で入るのを制限します。
 * 
 * 【動作確認バージョン】
 * MV v1.6.2
 * MZ v1.9.0
 * 
 * 【更新履歴】
 * 2025/06/04  v.0.50 公開
 * 
 * このプラグインにはプラグインパラメータやプラグインコマンドはありません。
 * 
 * -----------------------------------
 * ■茶川あくた
 * https://x.com/sorahune4
 * https://ci-en.net/creator/2698
 */

(function () {
    'use strict';
    // ================================================================================
    // Scene_Name
    // ================================================================================
    const _Scene_Name_prototype_create = Scene_Name.prototype.create;
    Scene_Name.prototype.create = function () {
        _Scene_Name_prototype_create.call(this);
        this._confirmed = false;
    };

    const _Scene_Name_prototype_onInputOk = Scene_Name.prototype.onInputOk;
    Scene_Name.prototype.onInputOk = function () {
        if (this._confirmed) return;
        this._confirmed = true;
        _Scene_Name_prototype_onInputOk.call(this);
    };
})();
